<?php
/* --------------------------------------------------------------
   UserConfigurationRepository.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration\Interfaces;

use Gambio\Admin\UserConfiguration\Exceptions\UserConfigurationNotFoundException;

/**
 * Class UserConfigurationRepository
 *
 * @package Gambio\Admin\UserConfiguration\Interfaces
 */
interface UserConfigurationRepository
{
    /**
     * @param UserId               $userId
     * @param UserConfigurationKey $key
     *
     * @return UserConfiguration
     *
     * @throws UserConfigurationNotFoundException
     */
    public function getByKey(UserId $userId, UserConfigurationKey $key): UserConfiguration;
    
    
    /**
     * @param UserId            $userId
     * @param UserConfiguration $configuration
     */
    public function store(UserId $userId, UserConfiguration $configuration): void;
    
    
    /**
     * @param UserId               $userId
     * @param UserConfigurationKey $key
     */
    public function deleteByKey(UserId $userId, UserConfigurationKey $key): void;
}